function [x_it, lambda_it] = get_x_it(CDX, date_num, method)
% --------------------------------------------------------------------------------------------------
% Get vector of firm-specific default intensities at certain date
% --------------------------------------------------------------------------------------------------
% CDX       ... credit index structure (see 'all_steps_in_a_row.m')
% date_num  ... date for which to extract X_it
% method    ... which X_it's to extract:
%               1 ... only index members on that date (default)
%               2 ... all CDS in the CDX structure
% --------------------------------------------------------------------------------------------------
% sample call:  get_x_it(cdx_new, datenum('02/01/2006'))
%               get_x_it(cdx_new, datenum('02/01/2006'), 2)
% --------------------------------------------------------------------------------------------------

if (nargin == 2)
    method = 1;
end

% Determine index members
pos = find(CDX.dates{1} == date_num);
if (method == 1)
    used = CDX.index_members(pos,:);
elseif (method == 2)
    used = ones(size(CDX.index_members, 2), 1);
end

% Extract instantaneous firm-specific default intensities
lambda_it = -ones(sum(used), 1);
x_it = -ones(sum(used), 1);
counter = 0;
for i=1:length(used)
    if (used(i) == 0)
        continue;
    end
    counter = counter + 1;
    cds = CDX.portfolio(i);
    pos2 = find(cds.dates{1} == date_num);
    % round intensity to 6 digits
    tmp = cds.x0(pos2) - cds.ai(pos2) * CDX.y0(pos);
    if (~isempty(tmp))
        x_it(counter) = round(tmp*1e6)/1e6;
        lambda_it(counter) = cds.x0(pos2);
    end
end